#include <cyg/hal/hal_arch.h>
#include <cyg/infra/diag.h>
#include <cyg/kernel/kapi.h>
#include <stdio.h>

#include "ezs_counter.h"
#include "ezs_trace.h"
#include "ezs_io_fel.h"
#include "ezs_sensor.h"
#include "ezs_dac.h"
#include "ezs_stopwatch.h"
#include "ezs_serial.h"

#include "ezs_utils.h"
#include "ezs_deadlines.hpp"

#ifdef SANITY_TEST
#include "ezs_test.h"
#include "ezs_lcd.h"
#endif

#define STACKSIZE CYGNUM_HAL_STACK_SIZE_MINIMUM+1024


// Assumptions that may be used:
//   - There are not more than 31 concurrent activations (the idle thread is at priority level 32)
#define MAX_ACTIVATIONS 32
//   - Constrained deadline system: every period is equal to the relative deadline
//   - Deadline violations do not have to be detected at the instant the deadline is violated.
//     A later detection is fine.
//   - Assume that all tasks will at some time finish their execution and signal their end via ezs_thread_suspend.
//     You do not need to account for infinitely running tasks.


// Thread 1
static cyg_uint8 my_stack[STACKSIZE];
static cyg_handle_t threadhndl1;
static cyg_thread   threaddata;
static cyg_alarm    alarm1;
static cyg_handle_t alarmhnd1;

// Reference to counter used by real-time clock.
static cyg_handle_t counter;

struct queue_element;
typedef struct queue_element {
	cyg_handle_t task;
	cyg_uint32 deadline;
	struct queue_element *next;
	bool in_use;
} edf_queue_t;

volatile edf_queue_t* queue; // dynamic management of tasks
edf_queue_t elems[MAX_ACTIVATIONS] = {{0}}; // static management of tasks

static edf_queue_t* alloc_queue_element(void) {
	for(size_t i = 0; i < sizeof(elems)/sizeof(*elems); i++) {
		if (!elems[i].in_use) {
			elems[i].in_use = true;
			elems[i].next = NULL;
			return &elems[i];
		}
	}
	die("Allocation of queue element failed");
}

/*!
 *  \brief Returns the number of ticks (cyg_current_time) since the last
 *  invocation of this function.
 *
 *  \return Number of passed ticks. 0 on first invocation.
 */
cyg_tick_count_t ezs_edf_pending_ticks(void) {
	/* TODO: implement */

	return 0;
}

/*!
 *  \brief Periodic update of the scheduling queue.
 *
 *  Updates queue state with number of acutally passed ticks.
 *  Checks for deadline violations.
 *
 * \param queue The queue to update.
 */
void ezs_edf_do_tick(edf_queue_t *queue) {
	/* TODO: implement */
}

/*!
 *  \brief Updates task priorities in a linear fashion.
 *
 *  Assigns the starting element `start` the given priority `prio` and updates
 *  the priority of all following accordingly.
 *
 *  \param start First element to update.
 *  \param prio Starting priority.
 */
static void ezs_edf_update_priorities(edf_queue_t *start, cyg_priority_t prio) {
	/* TODO: implement */
}

/*!
 *  \brief Inserts a new element at the correctly sorted position in the queue,
 *  updating the relative deadlines.
 *
 *  \param queue Scheduling queue
 *  \param to_insert element to insert into queue
 *  \return The element just before the inserted element.
 */
static edf_queue_t *ezs_edf_insert(edf_queue_t **queue, edf_queue_t *to_insert) {
	/* TODO: implement */

	return NULL;
}

void ezs_thread_resume(cyg_handle_t handle) {
	/* TODO:
	 * - handle ticks
	 * - insert task into list
	 * - update list elements
	 */

	// Do not forget to actually resume the task
	cyg_thread_resume(handle);
}

void ezs_thread_suspend(cyg_handle_t handle) {
	cyg_scheduler_lock();
	// Using this lock, code is run synchronous with the scheduler.
	/* TODO:
	 * - handle ticks
	 * - update deadlines
	 */
	cyg_scheduler_unlock();
	cyg_thread_suspend(handle);
}

void alarm_handler(cyg_handle_t alarm, cyg_addrword_t data)
{
	// Is run in DSR-context, so it is synchronous with the scheduler
	// 'data' is a pointer to a thread handle! (see cyg_alarm_create below)
	ezs_thread_resume(*((cyg_handle_t*) data));
}

// A little test thread.
void thread(cyg_addrword_t arg)
{
	while(1)
	{
		ezs_simulate_wcet(42, 100);
		ezs_thread_suspend(cyg_thread_self());
	}
}

void cyg_user_start(void)
{
	ezs_serial_init();
	ezs_sensors_init();
	ezs_dac_init();
	ezs_deadline_init();

	// Initialize EZS counter
	ezs_counter_init();

#ifdef SANITY_TEST
	ezs_lcd_init();
	ezs_fb_init();
	ezs_sanity_test();
#endif

	// Create test thread
	cyg_thread_create(11, &thread, 0, "Abtastung1", my_stack, STACKSIZE,
	                  &threadhndl1, &threaddata);

	// Get reference to counter used by real-time clock.
	cyg_clock_to_counter(cyg_real_time_clock(), &counter);

	/**
	 * BEWARE! Neiter ms_to_ezs_ticks nor ms_to_cyg_ticks are working!
	 * Fix them in order to complete this exercise
	 */

	cyg_uint32 test_period_ms = 100;
	cyg_tick_count_t test_period = ms_to_cyg_ticks(test_period_ms);

	// Register relative deadline of task.
	ezs_set_deadline(threadhndl1, test_period);

	// Create alarm. Notice the pointer to the threadhndl1 as alarm function parameter!
	cyg_alarm_create(counter, alarm_handler, (cyg_addrword_t) &threadhndl1 , &alarmhnd1, &alarm1);
	cyg_alarm_initialize(alarmhnd1, cyg_current_time() + 1, test_period);
	cyg_alarm_enable(alarmhnd1);

}
